%Hatton Cross Roundabout
%December 20, 2012
%Peter Miebach 100616681
%Pradeep Gunaratnam 100322776


%Checklist:
%COMPLETE -> convert assignment 2 roundabout rules to new CD++ version.
%COMPLETE -> fix assignment 2 issues (disappearing cars, car not following 
%roundabout rules) (and test).
%COMPLETE -> add logic for car speed so that car will not enter roundabout if
%car coming (2 cells away) is going too fast (and test).
%COMPLETE -> add logic for 'number of hops left' so that car entering mini-
%roundabout (numofhopsleft=0) is directed to exit (and test).
%COMPLETE -> add logic for 'number of hops left' so that car leaving mini-
%roundabout to another mini roundabout decrements 'numofhopsleft' by 1 (and test).
%COMPLETE -> connect mini-roundabout to DEVS input queue (and test).
%COMPLETE -> prepare car info for when car transisitions from one 
%mini-roundabout to another mini-roundabout and send to output port (and test).
%ISSUES -> connect mini-roundabouts to each other (and test).

%NOTE: DrawLog fails to draw the output due to the cell DEV output ports (out_west & out_east).


[top]
%setup for a single mini-roundabout (for testing)
%components :  queue@Queue roundabout 
%in : in done
%out : out_west out_east
%link : in in@queue
%link : done done@queue
%link : out@queue in_south@roundabout
%link : out_west@roundabout out_west
%link : out_east@roundabout out_east


%setup for a Hatton Cross roundabout system (6 mini-roundabouts connected to each other)
components : roundabout1 roundabout2 roundabout3 roundabout4 roundabout5 roundabout6
components : queue1@Queue queue2@Queue queue3@Queue queue4@Queue queue5@Queue queue6@Queue
in : in done
link : in in@queue1
link : in in@queue2
link : in in@queue3
link : in in@queue4
link : in in@queue5
link : in in@queue6
link : done done@queue1
link : done done@queue2
link : done done@queue3
link : done done@queue4
link : done done@queue5
link : done done@queue6
link : out@queue1 in_south@roundabout1
link : out@queue2 in_south@roundabout2
link : out@queue3 in_south@roundabout3
link : out@queue4 in_south@roundabout4
link : out@queue5 in_south@roundabout5
link : out@queue6 in_south@roundabout6
link : out_east@roundabout1 in_west@roundabout2
link : out_west@roundabout2 in_east@roundabout1
link : out_east@roundabout2 in_west@roundabout3
link : out_west@roundabout3 in_east@roundabout2
link : out_east@roundabout3 in_west@roundabout4
link : out_west@roundabout4 in_east@roundabout3
link : out_east@roundabout4 in_west@roundabout5
link : out_west@roundabout5 in_east@roundabout4
link : out_east@roundabout5 in_west@roundabout6
link : out_west@roundabout6 in_east@roundabout5
link : out_east@roundabout6 in_west@roundabout1
link : out_west@roundabout1 in_east@roundabout6


[queue1]
preparation : 00:00:00:000
[queue2]
preparation : 00:00:00:000
[queue3]
preparation : 00:00:00:000
[queue4]
preparation : 00:00:00:000
[queue5]
preparation : 00:00:00:000
[queue6]
preparation : 00:00:00:000





[queue]
preparation : 00:00:00:000

[roundabout]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
%local neighbors (increased to 2 for speedport):
neighbors : roundabout(-2,-2) roundabout(-2,-1) roundabout(-2,0) roundabout(-2,1) roundabout(-2,2) 
neighbors : roundabout(-1,-2) roundabout(-1,-1) roundabout(-1,0) roundabout(-1,1) roundabout(-1,2)
neighbors : roundabout(0,-2)  roundabout(0,-1)  roundabout(0,0)  roundabout(0,1)  roundabout(0,2)
neighbors : roundabout(1,-2)  roundabout(1,-1)  roundabout(1,0)  roundabout(1,1)  roundabout(1,2)
neighbors : roundabout(2,-2)  roundabout(2,-1)  roundabout(2,0)  roundabout(2,1)  roundabout(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000

%Setup ports and links for cars queue into Hattoncross roundabout:
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout(4,4)
link : in_west in_west@roundabout(2,1)
link : in_east in_east@roundabout(1,6)
link : out_west@roundabout(1,1) out_west
link : out_east@roundabout(2,6) out_east

portInTransition : in_south@roundabout(4,4) carinput-rule
portInTransition : in_west@roundabout(2,1) carinput-rule
portInTransition : in_east@roundabout(1,6) carinput-rule
localtransition : roundabout-rule



statevariables: direction isexit initDone testinitDone
%direction:    North = 1, East = 2, South = 3, West = 4
%isexit:       specify if the cell is an exit and which one (West Exit = 7, South Exit = 8, East Exit = 9, not an exit = 0)
%initDone:     To initialize each cell to make sure all cells are outputing their direction
%testinitDone: For testing purposes only (insert cars into model to test roundabout and connector logic)
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues

neighborports : exitnumberport numhopsleftport speedport directionport isexitport
%exitnumberport:   If car is present in cell, indicates what exit it will leave at. (West Exit = 7, South Exit = 8, East Exit = 9, empty road = 1)
%numhopsleftport:  number of roundabouts car must pass through before leaving Hattoncross
%speedport:        speed of car travelling through roundabout
%directionport:    output cell's direction to neighbour cells
%isexitport:       indicate to neighbour cells what exit I am or if I'm not an exit.
%DrawLog Note: Make sure port variables are in lower case otherwise DrawLog does not work!



[carinput-rule]
rule :  { ~exitnumberport := 7;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 700) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 700) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 7}
rule :  { ~exitnumberport := 8;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 800) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 800) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 8}
rule :  { ~exitnumberport := 9;
		  ~numhopsleftport := (trunc((portValue(thisPort) - 900) / 10));
		  ~speedport := ((fractional((portValue(thisPort) - 900) / 10)) * 10); }
		100 
		{trunc(portValue(thisPort) / 100) = 9}
rule : { (0,0) } 0 { t }






[roundabout-rule]
%/////////////////////////////INITIALIZATION///////////////////////////
%initialization of cells (to be run only once by each cell)
rule : { ~directionport := $direction; 
		 ~isexitport := $isexit;
		 ~exitnumberport := (0,0)~exitnumberport;
		 ~numhopsleftport := 0;} 
       { $initDone:=1;} 
	   100 
	   { $direction > 0 and
         $initDone =0 }
%///////////////////////END OF INITIALIZATION/////////////////////////
		 

		 
		 
		 
		 
		 
		 
		 

%///////////////////////////////TESTING//////////////////////////////
%Testing allows the user to input cars into the system with desired variables


%test general roundabout rules (obsolete! DO NOT USE!)
%initialrowvalue :  0     00000000
%initialrowvalue :  1     01181990
%initialrowvalue :  2     07800810
%initialrowvalue :  3     00911700
%initialrowvalue :  4     00018000
%initialrowvalue :  5     00000000



		 
%test numhopsleftport for car entering mini roundabout (can just test one at a time)
%(2,1)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,0)~isexitport = 7 and
%         $testinitDone =0}
%(4,4)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 8 and
%         $testinitDone =0}
%(1,6)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 0;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,0)~isexitport = 9 and
%         $testinitDone =0}
	   
%test numhopsleftport for car leaving mini roundabout to another mini roundabout (can just test one at a time)
%(3,3) -> dont need to test since car leaves Hatton Cross system
%(1,2)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 4;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 7 and
%         $testinitDone =0}
%(2,5)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 4;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,1)~isexitport = 9 and
%         $testinitDone =0}	   
	   
%test speedport (test one set(2 cells) at a time):
%(2,1)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,0)~isexitport = 7 and
%         $testinitDone =0}
%(1,3)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-2)~isexitport = 7 and
%         $testinitDone =0}

%(4,4)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (0,-1)~isexitport = 8 and
%         $testinitDone =0}
%(3,2)
%rule : { ~exitnumberport := 9;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,1)~isexitport = 8 and
%         $testinitDone =0}

%(1,6)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 1;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (1,0)~isexitport = 9 and
%         $testinitDone =0}
%(3,5)
%rule : { ~exitnumberport := 7;
%         ~numhopsleftport := 1;
%		 ~speedport := 2;} 
%       {$testinitDone:=1; } 
%	   100 
%	   { (-1,1)~isexitport = 9 and
%         $testinitDone =0}		 
%///////////////////////////END OF TESTING///////////////////////////
	   
	   
	   

%///////////////////////////////RULES///////////////////////////////


%%%%%%%%%%%%%%%%%%%cars going into cells:
%(2,2)
%%car in loop gets priority (ignore car 7 since it leaves at 7):
rule : { ~exitnumberport := (-1,0)~exitnumberport;
         ~numhopsleftport := (-1,0)~numhopsleftport; 
		 ~speedport := (-1,0)~speedport;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       { } 
	   100 
	   { (0,0)~exitnumberport = 1 and 
	   (-1,0)~exitnumberport > 1 and 
	   (-1,0)~exitnumberport != 7 and 
	   (-1,0)~directionport = 3 and 
	   (-1,-1)~isexitport = 7 and
	   $direction =3 and 
	   $isexit =0 }
%check if car that is entering is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : { ~exitnumberport := 8;
         ~numhopsleftport := 0; 
		 ~speedport := (0,-1)~speedport;		 
	    ~directionport := $direction; 
	    ~isexitport := $isexit;}		
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(0,-1)~numhopsleftport = 0 and
		(-1,1)~speedport != 2 and
        $direction =3 and
		(-1,-1)~isexitport = 7 and
        $isexit =0 }	   
rule : { ~exitnumberport := (0,-1)~exitnumberport;
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	    ~directionport := $direction; 
	    ~isexitport := $isexit;}		
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(-1,1)~speedport != 2 and
        $direction =3 and
		(-1,-1)~isexitport = 7 and
        $isexit =0 }

%(3,2)
rule : {~exitnumberport := (-1,0)~exitnumberport; 
         ~numhopsleftport := (-1,0)~numhopsleftport;
		 ~speedport := (-1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (-1,0)~exitnumberport > 1 and 
        (-1,0)~directionport = 3 and
        $direction =2 and
		(1,1)~isexitport = 8 and
        $isexit =0 }


%(3,3)
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
        (1,0)~isexitport = 8 and
		$direction =2 and
        $isexit =0 }

%(3,4)
%%car in loop gets priority (ignore car 8 since it leaves at 8):
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and
        (0,-1)~exitnumberport > 1 and
        (0,-1)~exitnumberport != 8 and
        (0,-1)~directionport = 2 and
		(1,-1)~isexitport = 8 and
        $direction =2 and
        $isexit =0}
%check if car is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : {~exitnumberport := 8;
         ~numhopsleftport := 0;
		 ~speedport := (1,0)~speedport;	 
	   ~directionport := $direction;
	   ~isexitport := $isexit;}
       {}
       100
       { (0,0)~exitnumberport = 1 and
        (1,0)~exitnumberport > 1 and
		(1,0)~numhopsleftport = 0 and
		(0,-2)~speedport != 2 and
		(1,-1)~isexitport = 8}
rule : {~exitnumberport := (1,0)~exitnumberport;
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;	 
	   ~directionport := $direction;
	   ~isexitport := $isexit;}
       {}
       100
       { (0,0)~exitnumberport = 1 and
         (1,0)~exitnumberport > 1 and
		 (0,-2)~speedport != 2 and
         (1,-1)~isexitport = 8}
		


%(3,5)        
rule : {~exitnumberport := (0,-1)~exitnumberport; 
         ~numhopsleftport := (0,-1)~numhopsleftport; 
		 ~speedport := (0,-1)~speedport;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport > 1 and 
        (0,-1)~directionport = 2 and
		(-1,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0}

%(2,5)    
rule: {~exitnumberport := (1,0)~exitnumberport; 
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
      { }
      100 
      { (0,0)~exitnumberport = 1 and 
        (1,0)~exitnumberport > 1 and 
        (1,0)~directionport = 1 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0}

%(1,5)
%%car in loop gets priority (ignore car 9 since it leaves at 9):
rule : {~exitnumberport := (1,0)~exitnumberport; 
         ~numhopsleftport := (1,0)~numhopsleftport;
		 ~speedport := (1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (1,0)~exitnumberport > 1 and 
        (1,0)~exitnumberport != 9 and
        (1,0)~directionport = 1 and
		(1,1)~isexitport = 9 and
        $direction = 4 and
        $isexit = 0 }
		
%check if car is leaving the overall roundabout system
%if so then change exit # to '8'
%also check if car two cells away is speeding
rule : {~exitnumberport := 8;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       {}
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(0,1)~numhopsleftport = 0 and
		(2,0)~speedport != 2 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }		
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       {}
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(2,0)~speedport != 2 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }
 
%(1,4)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(1,1)~exitnumberport > 0 and
		(1,2)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }

%(1,3)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(1,-1)~exitnumberport > 0 and
        $direction =4 and
		(0,-2)~isexitport = 7 and
        $isexit =0 }
        
%(1,2)
rule : {~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport;
		 ~speedport := (0,1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport > 1 and 
        (0,1)~directionport = 4 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }
		
%%%%%%%%%%%%%car going into exit cell
%(1,1) car going to left mini-roundabout
rule : { ~exitnumberport := (0,1)~exitnumberport;
         ~numhopsleftport := (0,1)~numhopsleftport; 
		~speedport := (0,1)~speedport; 
		~directionport := $direction;
		~isexitport := $isexit;} 
		100 
       { (0,0)~exitnumberport = 1 and 
        (0,1)~exitnumberport = 7 and 
        (0,1)~directionport = 3 and
		(0,0)~isexitport = 7 and
        $direction =4 and
        $isexit =7 }

	
%(2,6) car going to right mini-roundabout
rule : { ~exitnumberport := (0,-1)~exitnumberport;
		~numhopsleftport := (0,-1)~numhopsleftport;
		 ~speedport := (0,-1)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       100 
       { (0,0)~exitnumberport = 1 and 
        (0,-1)~exitnumberport = 9 and 
        (0,-1)~directionport = 1 and
		(0,0)~isexitport = 9 and
        $direction =2 and
        $isexit =9 }

%(4,3) car leaving Hattoncross roundabout system
rule : {~exitnumberport := (-1,0)~exitnumberport;
         ~numhopsleftport := (-1,0)~numhopsleftport;
		 ~speedport := (-1,0)~speedport;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport = 1 and 
        (-1,0)~exitnumberport = 8 and 
        (-1,0)~directionport = 2 and
		(0,0)~isexitport = 8 and
        $direction =3 and
        $isexit =8 }
		


		
%%%%%%%%%%%%%%%%%%%cars leaving cells:		

%clear cells in roundabout

%(2,2)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
	   { (0,0)~exitnumberport > 1 and 
	   (1,0)~exitnumberport = 1 and 
	   (1,0)~directionport = 2 and 
	   (-1,-1)~isexitport = 7 and
	   $direction =3 and 
	   $isexit =0 }
	   
%(3,2)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(1,1)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }
		
%(3,3)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0; 
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 8 and 
        (1,0)~exitnumberport = 1 and 
        (1,0)~directionport = 3 and
		(1,0)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }
		
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;  
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and
         (0,0)~exitnumberport != 8 and	   
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(1,0)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }

%(3,4)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;  
		 		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 1 and
		(1,-1)~isexitport = 8 and
        $direction =2 and
        $isexit =0 }

		
%(3,5)
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (-1,0)~exitnumberport = 1 and 
        (-1,0)~directionport = 1 and
		(-1,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }		

%(2,5)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 9 and 
        (0,1)~exitnumberport = 1 and 
        (0,1)~directionport = 2 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
	     (0,0)~exitnumberport != 9 and
        (-1,0)~exitnumberport = 1 and 
        (-1,0)~directionport = 4 and
		(0,1)~isexitport = 9 and
        $direction =1 and
        $isexit =0 }	

%(1,5)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0; 
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(1,1)~isexitport = 9 and
        $direction =4 and
        $isexit =0}

%(1,4)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(0,1)~directionport = 4 and
        $direction =4 and
        $isexit =0 }		
		
%(1,3)
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 3 and
		(0,1)~directionport = 4 and
        $direction =4 and
        $isexit =0 }

%(1,2)
%%first check if car left at exit
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport = 7 and 
        (0,-1)~exitnumberport = 1 and 
        (0,-1)~directionport = 4 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }
rule : { ~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
	     (0,0)~exitnumberport != 7 and 
        (1,0)~exitnumberport = 1 and 
        (1,0)~directionport = 3 and
		(0,-1)~isexitport = 7 and
        $direction =3 and
        $isexit =0 }


%clear entrance cells:	


%(2,1)
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1;
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (0,1)~exitnumberport = 1 and 
        ( (-1,1)~exitnumberport = 1 or (-1,1)~exitnumberport = 7 ) and 
        (0,1)~directionport = 3 and
		(-1,2)~speedport != 2 and
		(-1,0)~isexitport = 7 and
        $direction =2 and
        $isexit =0 }
	
%(4,4)
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
	   ( (-1,-1)~exitnumberport = 1 or (-1,-1)~exitnumberport = 8 ) and
        (-1,0)~exitnumberport = 1 and
		(-1,-2)~speedport != 2 and
		(0,-1)~isexitport = 8}

%(1,6)		
%car didnt move if car 2 cells away was speeding
rule : {~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 		 ~speedport := 0;
	   ~directionport := $direction; 
	   ~isexitport := $isexit;} 
       { }
       100 
       { (0,0)~exitnumberport > 1 and 
        (0,-1)~exitnumberport = 1 and 
        ( (1,-1)~exitnumberport = 1 or (1,-1)~exitnumberport = 9 ) and  
        (0,-1)~directionport = 4 and
		(2,-1)~speedport != 2 and
		(1,0)~isexitport = 9 and
        $direction =4 and
        $isexit =0 }		


%%%%%%%%%clear exit cells:
%if car going to another mini-roundabout, decrement 'numhopsleftport' by 1
%send car information (exit#, numhops, speed) to output port
%(1,1)
rule : { ~exitnumberport := (1 + send (out_west, (((0,0)~exitnumberport * 100) + (((0,0)~numhopsleftport - 1) * 10) + (0,0)~speedport))); 
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =7 }	
		
%(2,6)
rule : { ~exitnumberport := (1 + send (out_east, (((0,0)~exitnumberport * 100) + (((0,0)~numhopsleftport - 1) * 10) + (0,0)~speedport))); 
         ~numhopsleftport := 0;
		 ~speedport := 0;		 
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =9 }
		
%(4,3)
rule : { ~exitnumberport := 1; 
         ~numhopsleftport := 0; 
		 ~speedport := 0;
         ~directionport := $direction; 
		 ~isexitport := $isexit;} 
       {} 
	   100 
       { (0,0)~exitnumberport > 1 and 
        $isexit =8 }
	
		
rule : {(0,0)} 100 {t}
%////////////////////////////END OF RULES///////////////////////////










%/////////For Hatton Cross Roundabout testing////////////////////////
[roundabout1]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout1(-2,-2) roundabout1(-2,-1) roundabout1(-2,0) roundabout1(-2,1) roundabout1(-2,2) 
neighbors : roundabout1(-1,-2) roundabout1(-1,-1) roundabout1(-1,0) roundabout1(-1,1) roundabout1(-1,2)
neighbors : roundabout1(0,-2)  roundabout1(0,-1)  roundabout1(0,0)  roundabout1(0,1)  roundabout1(0,2)
neighbors : roundabout1(1,-2)  roundabout1(1,-1)  roundabout1(1,0)  roundabout1(1,1)  roundabout1(1,2)
neighbors : roundabout1(2,-2)  roundabout1(2,-1)  roundabout1(2,0)  roundabout1(2,1)  roundabout1(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout1(4,4)
link : in_west in_west@roundabout1(2,1)
link : in_east in_east@roundabout1(1,6)
link : out_west@roundabout1(1,1) out_west
link : out_east@roundabout1(2,6) out_east
portInTransition : in_south@roundabout1(4,4) carinput-rule
portInTransition : in_west@roundabout1(2,1) carinput-rule
portInTransition : in_east@roundabout1(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport

[roundabout2]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout2(-2,-2) roundabout2(-2,-1) roundabout2(-2,0) roundabout2(-2,1) roundabout2(-2,2) 
neighbors : roundabout2(-1,-2) roundabout2(-1,-1) roundabout2(-1,0) roundabout2(-1,1) roundabout2(-1,2)
neighbors : roundabout2(0,-2)  roundabout2(0,-1)  roundabout2(0,0)  roundabout2(0,1)  roundabout2(0,2)
neighbors : roundabout2(1,-2)  roundabout2(1,-1)  roundabout2(1,0)  roundabout2(1,1)  roundabout2(1,2)
neighbors : roundabout2(2,-2)  roundabout2(2,-1)  roundabout2(2,0)  roundabout2(2,1)  roundabout2(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout2(4,4)
link : in_west in_west@roundabout2(2,1)
link : in_east in_east@roundabout2(1,6)
link : out_west@roundabout2(1,1) out_west
link : out_east@roundabout2(2,6) out_east
portInTransition : in_south@roundabout2(4,4) carinput-rule
portInTransition : in_west@roundabout2(2,1) carinput-rule
portInTransition : in_east@roundabout2(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport

[roundabout3]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout3(-2,-2) roundabout3(-2,-1) roundabout3(-2,0) roundabout3(-2,1) roundabout3(-2,2) 
neighbors : roundabout3(-1,-2) roundabout3(-1,-1) roundabout3(-1,0) roundabout3(-1,1) roundabout3(-1,2)
neighbors : roundabout3(0,-2)  roundabout3(0,-1)  roundabout3(0,0)  roundabout3(0,1)  roundabout3(0,2)
neighbors : roundabout3(1,-2)  roundabout3(1,-1)  roundabout3(1,0)  roundabout3(1,1)  roundabout3(1,2)
neighbors : roundabout3(2,-2)  roundabout3(2,-1)  roundabout3(2,0)  roundabout3(2,1)  roundabout3(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout3(4,4)
link : in_west in_west@roundabout3(2,1)
link : in_east in_east@roundabout3(1,6)
link : out_west@roundabout3(1,1) out_west
link : out_east@roundabout3(2,6) out_east
portInTransition : in_south@roundabout3(4,4) carinput-rule
portInTransition : in_west@roundabout3(2,1) carinput-rule
portInTransition : in_east@roundabout3(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport


[roundabout4]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout4(-2,-2) roundabout4(-2,-1) roundabout4(-2,0) roundabout4(-2,1) roundabout4(-2,2) 
neighbors : roundabout4(-1,-2) roundabout4(-1,-1) roundabout4(-1,0) roundabout4(-1,1) roundabout4(-1,2)
neighbors : roundabout4(0,-2)  roundabout4(0,-1)  roundabout4(0,0)  roundabout4(0,1)  roundabout4(0,2)
neighbors : roundabout4(1,-2)  roundabout4(1,-1)  roundabout4(1,0)  roundabout4(1,1)  roundabout4(1,2)
neighbors : roundabout4(2,-2)  roundabout4(2,-1)  roundabout4(2,0)  roundabout4(2,1)  roundabout4(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout4(4,4)
link : in_west in_west@roundabout4(2,1)
link : in_east in_east@roundabout4(1,6)
link : out_west@roundabout4(1,1) out_west
link : out_east@roundabout4(2,6) out_east
portInTransition : in_south@roundabout4(4,4) carinput-rule
portInTransition : in_west@roundabout4(2,1) carinput-rule
portInTransition : in_east@roundabout4(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport

[roundabout5]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout5(-2,-2) roundabout5(-2,-1) roundabout5(-2,0) roundabout5(-2,1) roundabout5(-2,2) 
neighbors : roundabout5(-1,-2) roundabout5(-1,-1) roundabout5(-1,0) roundabout5(-1,1) roundabout5(-1,2)
neighbors : roundabout5(0,-2)  roundabout5(0,-1)  roundabout5(0,0)  roundabout5(0,1)  roundabout5(0,2)
neighbors : roundabout5(1,-2)  roundabout5(1,-1)  roundabout5(1,0)  roundabout5(1,1)  roundabout5(1,2)
neighbors : roundabout5(2,-2)  roundabout5(2,-1)  roundabout5(2,0)  roundabout5(2,1)  roundabout5(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout5(4,4)
link : in_west in_west@roundabout5(2,1)
link : in_east in_east@roundabout5(1,6)
link : out_west@roundabout5(1,1) out_west
link : out_east@roundabout5(2,6) out_east
portInTransition : in_south@roundabout5(4,4) carinput-rule
portInTransition : in_west@roundabout5(2,1) carinput-rule
portInTransition : in_east@roundabout5(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport

[roundabout6]
type : cell
width : 8
height : 6
delay : transport
defaultDelayTime : 100
border : nonwrapped 
neighbors : roundabout6(-2,-2) roundabout6(-2,-1) roundabout6(-2,0) roundabout6(-2,1) roundabout6(-2,2) 
neighbors : roundabout6(-1,-2) roundabout6(-1,-1) roundabout6(-1,0) roundabout6(-1,1) roundabout6(-1,2)
neighbors : roundabout6(0,-2)  roundabout6(0,-1)  roundabout6(0,0)  roundabout6(0,1)  roundabout6(0,2)
neighbors : roundabout6(1,-2)  roundabout6(1,-1)  roundabout6(1,0)  roundabout6(1,1)  roundabout6(1,2)
neighbors : roundabout6(2,-2)  roundabout6(2,-1)  roundabout6(2,0)  roundabout6(2,1)  roundabout6(2,2)
initialvalue : 0
initialrowvalue :  0     00000000
initialrowvalue :  1     01111110
initialrowvalue :  2     01100110
initialrowvalue :  3     00111100
initialrowvalue :  4     00011000
initialrowvalue :  5     00000000
in : in_south in_west in_east
out : out_west out_east
link : in_south in_south@roundabout6(4,4)
link : in_west in_west@roundabout6(2,1)
link : in_east in_east@roundabout6(1,6)
link : out_west@roundabout6(1,1) out_west
link : out_east@roundabout6(2,6) out_east
portInTransition : in_south@roundabout6(4,4) carinput-rule
portInTransition : in_west@roundabout6(2,1) carinput-rule
portInTransition : in_east@roundabout6(1,6) carinput-rule
localtransition : roundabout-rule
statevariables: direction isexit initDone testinitDone
statevalues:   0 0 0 0
initialvariablesvalue: roundabout.stvalues
neighborports : exitnumberport numhopsleftport speedport directionport isexitport